/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */    
package com.ejie.p06b.log;

import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;

/** Genera salida de depuracion en la definida en 'log.adapter' de properties.
 *     Se basa en dos niveles de depuracin, el definido por la aplicacin
 *     y el definido por el usuario, siempre se basa en el que tenga mas peso. Por
 *     ejemplo, si la aplicacin tiene un 0-bajo pero queremos observar a un usuario
 *     en concreto, al usuario le pondramos un 2 y reflejara mas detalle en sus
 *     operaciones. Si ponemos un 2 a la aplicacin, aunque un usuario tenga
 *     poco detalle se mostrarn sus trazas.
 */  

public class P06BLog {
	
	private static  P06BILog adapter;
  
 /** Recibe: Nivel de debug (0-Bajo, 1-Medio, 2-Alto), clase perfil usuario
     de donde recoger el nivel de debug del usuario y su identificador,
     el objeto que gener el mensaje y el texto a mostrar.
  */  
	public static void send(int nivel, P06BPerfilUsuario perfil, Object src, String message)
	{
		if (adapter == null)
		{
			try
			{
      			String adapName = P06BParametros.get("log.adapter");
				adapter = ( P06BILog)Class.forName(adapName).newInstance();
			}
			catch (Exception e)
			{
				altLog(src,message+e);
				return;
			}
		}
		
		try
		{
      			if ( nivel <= perfil.getNivelLog() ||            
      				nivel <= new Integer (P06BParametros.get("log.nivel")).intValue() )
			   adapter.lanza(perfil,src,message);
		}
		catch (Exception e)
		{
			altLog(src,message + e);
		}
	}

 /** Recibe: Nivel de debug (0-Bajo, 1-Medio, 2-Alto), 
     el objeto que gener el mensaje y el texto a mostrar.
  */  
  public static void send(int nivel, Object src, String message) {
    if (adapter == null) {
      try {
       String adapName = P06BParametros.get("log.adapter");
       adapter = ( P06BILog)Class.forName(adapName).newInstance();
      } catch (Exception e) {
        altLog(src,message+e);
        return;
      }
    }
    
    try {
      if ( nivel <= new Integer (P06BParametros.get("log.nivel")).intValue() )
          adapter.lanza(src,message);
      else
      	 altLog(src,message);	
    } catch (Exception e) {
      altLog(src,message + e);
    }
  }

	private static void altLog(Object src, String message)	{
		System.out.println( src.toString() + "|LOG ERROR[" + message + "]");
	}
}
